var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-11-22\">\n      <meta name=\"topicid\" content=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0\">\n      <meta name=\"indexterm\" content=\"ラップ デフォーマ: nCloth で使用\">\n      <meta name=\"indexterm\" content=\"nCloth: ラップ デフォーマで使用\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>レッスン 3: 高解像度メッシュをラップしてアニメーション時にズボンをシミュレートする</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0\"></a><div class=\"head\">\n            <h1>レッスン 3: 高解像度メッシュをラップしてアニメーション時にズボンをシミュレートする</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A4D\"></a> このレッスンでは、以下の操作を行います。 \n            	 \n         </p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A4C\"></a><ul>\n            <li>高解像度メッシュ(Pants_HighRes)の動作に影響するラップ デフォーマを作成します。 \n               		\n            </li>\n            <li>ジオメトリ キャッシュを読み込んで胴体(nRigid_Body)と靴(nRigid_Shoes)のメッシュをアニメートします。 \n               		\n            </li>\n            <li>シミュレートされた nCloth ズボン オブジェクトに対して nCache を作成します。 \n               		\n            </li>\n            <li>nCloth とパッシブ衝突オブジェクト間の不正確な衝突検出や nCloth 内の自己衝突が原因となって引き起こされる、不完全に変形されたポリゴンや相互貫通などのシミュレーションの問題領域を特定します。\n               \n               		\n            </li>\n            <li>nucleus ソルバの<span class=\"MenuCascade\" id=\"GUID-D879709A-35AE-4A72-A7F3-990A01CBFCEC\">サブステップ(Substeps)</span>を編集し、シミュレーション全体の精度を改善します。 \n               		\n            </li>\n            <li>キーフレームを設定し、シミュレーションで問題になる特定のフレームで<span class=\"MenuCascade\" id=\"GUID-29EC1570-C0CF-4069-8887-E854F6F55D5B\">サブステップ(Substeps)</span>値を増やします。 \n               		\n            </li>\n            <li>相互貫通を解決します。 \n               		\n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A42\"></a> \n            <h2><a name=\"GUID-8A379278-0B27-4CFE-90D5-4291AF0ACE8B\"></a>レッスンのセットアップ\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A41\"></a>説明どおりにレッスンを進めるために、レッスンを開始する前に次の手順を実行します。 \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A40\"></a><ol type=\"1\" start=\"1\">\n               <li>nCloth の高度なテクニックのレッスン データをダウンロードしていない場合は、<a href=\"http://www.autodesk.co.jp/maya-advancedtechniques\" target=\"_blank\">http://www.autodesk.co.jp/maya-advancedtechniques</a> からダウンロードします。その後、<span class=\"code\">nClothAdvancedTutorials</span> ディレクトリを Maya プロジェクトとして設定します。 \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3E\"></a>このレッスンでは、レッスンのシーン ファイルに加えて、Maya ジオメトリのキャッシュ ファイルにアクセスする必要があります。 \n                     			 \n                  </p> \n               </li>\n               <li><span class=\"code\">Character_LowRes_3.mb</span> という名前のシーン ファイルを開きます。 \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3C\"></a>このファイルは、Maya プロジェクトとして設定した <span class=\"code\">nClothAdvancedTutorials</span> ディレクトリ内にあります。 \n                     			 \n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3B\"></a> \n            <h2><a name=\"GUID-D04C5E0B-FA19-41BD-AA71-597D83778190\"></a>高解像度メッシュをラップする\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3A\"></a>このレッスンでは、ラップ デフォーマを使用してシミュレートされた低解像度メッシュのように高解像度メッシュを動作させるインフルエンス オブジェクトを作成します。ラップ\n               デフォーマの詳細については、Maya ヘルプの「<em class=\"mild\">ラップ デフォーマ</em>」を参照してください。 \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A39\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A38\"></a>高解像度メッシュをラップするには\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li><span class=\"MenuCascade\" id=\"GUID-D7C95440-412E-4622-9D7C-E54DC64D7441\">アウトライナ(Outliner)</span>で <em class=\"mild\">Character_HighRes</em> を展開し、<em class=\"mild\">Pants_HighRes</em> オブジェクトを選択してから<span class=\"MenuCascade\" id=\"GUID-96A4F083-DB3D-4911-94FC-D9FA35BCAB12\">ディスプレイ &gt; 表示 &gt; 選択項目の表示(Display &gt; Show &gt; Show Selection)</span>を選択することによって、このオブジェクトを表示します。 \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E38\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-871934FF-2051-4179-8F03-62B9365F9EF3-low.png\"></div> \n               </li>\n               <li> Ctrl キーを押しながら nCloth ズボン(Character_LowRes&gt;Pants_LowRes)を選択します。 \n                  		  \n               </li>\n               <li><span class=\"MenuCascade\">アニメーション(Animation)</span>メニュー セットから、<span class=\"MenuCascade\">アニメーション デフォーム &gt; フル デフォーム メニューを開く(Anim Deform &gt; Open Full Deform Menu)</span>を選択します。 \n                  		  \n               </li>\n               <li>表示される <span class=\"MenuCascade\">デフォーム(Deform)</span>メニューから、<span class=\"MenuCascade\">ラップ(Wrap)</span>を選択します。 \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A34\"></a><span class=\"MenuCascade\" id=\"GUID-69F48498-09AA-49DC-B482-A1217D7F9127\">アトリビュート エディタ(Attribute Editor)</span>にラップ ノードが表示され、<span class=\"MenuCascade\" id=\"GUID-E3F812CA-DFF1-42AB-8197-86921BFBC5A6\">アウトライナ(Outliner)</span>では<em class=\"mild\">Pants_LowResBase</em> オブジェクトが <em class=\"mild\">Character_LowRes </em>グループに追加されるのを確認できます。 \n                     			 \n                  </p> \n                  <div><a name=\"WS73099CC142F487557230B50811D7D192C64-74AA\"></a><div class=\"note-note\"><span class=\"label label-target-language\">注:</span> \n                        <p><a name=\"GUID-204D14C9-D02B-4BD2-8F05-FB29536A5EA0\"></a>必要に応じて <em class=\"mild\">Character_LowRes</em> を展開し、<span class=\"MenuCascade\" id=\"GUID-77FEFCEA-9D57-4163-BF88-1A24CF87A563\">アウトライナ(Outliner)</span>で <em class=\"mild\"> Pant_LowResBase</em> オブジェクトを確認してください。 \n                           				\n                        </p> \n                     </div>\n                  </div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E37\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-60E27646-D24E-4ECE-AF3E-BBEF1EF95FF9-low.png\"></div> \n               </li>\n               <li><span class=\"MenuCascade\" id=\"GUID-EA461F5A-0794-40F0-9B17-65ED482DFF0A\">アトリビュート エディタ(Attribute Editor)</span>で、<span class=\"MenuCascade\" id=\"GUID-96A8EFD2-882B-4A51-94B4-B9B850672957\">wrap1</span> タブをクリックします。 \n                  		  \n               </li>\n               <li><span class=\"MenuCascade\" id=\"GUID-D3EB34B1-AFF6-4682-86D3-71059105AD8C\">ラップ アトリビュート(Wrap Attributes)</span>セクションで、<span class=\"MenuCascade\" id=\"GUID-7B3ACC42-3206-4C95-AED9-EDB4B07C1DD5\">排他バインド(Exclusive Bind)</span>をオンにします。 \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E36\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-392C1528-D8AC-4FF7-8BD7-4467F7080E35-low.png\"></div> \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A31\"></a><span class=\"MenuCascade\" id=\"GUID-8929749E-0E99-4018-8716-DB4279DA7103\">排他バインド(Exclusive Bind)</span>をオンにすると、Pants_HighRes オブジェクト上の各サーフェス ポイント(頂点)が Pants_LowRes オブジェクトの頂点によってコンストレイントされるか作用されます。これにより、Pants_HighRes\n                     オブジェクトはシミュレートされる nCloth ズボンのプロパティを確実に継承します。 \n                     			 \n                  </p> \n               </li>\n               <li> <span class=\"MenuCascade\" id=\"GUID-57AFE3B2-43A2-4C49-95B6-517B28C46844\">アウトライナ(Outliner)</span>で Pants_LowRes オブジェクトを選択し、<span class=\"MenuCascade\" id=\"GUID-F6C46E14-D7B0-43E0-B76B-84C9D6D8E81C\">ディスプレイ &gt; 非表示 &gt; 選択項目の非表示(Display &gt; Hide &gt; Hide Selection)</span>を選択して、Pants_LowRes オブジェクトを非表示にします。 \n                  		  \n               </li>\n               <li> シミュレーションを再生します。 \n                  		  \n               </li>\n            </ol> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2F\"></a>シミュレーションを再生すると、次のことがわかります。 \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E35\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-34913F38-CD86-4EE6-8EE1-3FA55C869327-low.png\"></div> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2E\"></a><ul>\n               <li>Pants_HighRes オブジェクトがまるで nCloth オブジェクトをシミュレートしているかのように見えます。 \n                  		  \n               </li>\n               <li>解像度のスピードが遅くなったり Pants_HighRes オブジェクトに作用されることはありません。 \n                  		  \n               </li>\n            </ul> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2B\"></a>ポリゴン数の多い Pants_HighRes オブジェクトでは、シミュレーション速度は遅くなると思われるかもしれません。ところが、実際には速度が遅くなることはありません。これは\n               nucleus ソルバが Pants_HighRes オブジェクトに接続されたデータをシミュレートしないためです。シミュレーションに含まれる nucleus 計算はすべて、引き続き低解像度の\n               nCloth ズボン上で実行されます。Pants_HighRes オブジェクトの動作は、シミュレートされる nCloth の新しいインスタンスである Pants_LowResBase\n               オブジェクトの影響を受けます。 \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2A\"></a>Pants_LowResBase オブジェクトは Pants_HighRes オブジェクトのデフォメーションに対するベースのシェイプで、これがラップ インフルエンス\n               オブジェクトです。すべてのラップ デフォーマと同様に、ベースのシェイプとラップ インフルエンス オブジェクト間の位置、方向、またはシェイプの差に基づいて、ラップ デフォーマによるインフルエンスを受けているサーフェスが変形します。\n               \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A29\"></a> \n            <h2><a name=\"GUID-A288B5DC-C11C-41C0-8DCB-6212DAA4DEC1\"></a>アニメートされたキャラクタの nCloth ズボンをシミュレートする\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A28\"></a>このセクションでは、nRigid の胴体オブジェクトと nRigid の靴オブジェクトに対するジオメトリ キャッシュを読み込み、胴体と靴をアニメートしながら nCloth\n               ズボン オブジェクトのシミュレートを開始します。 \n               		\n            </p> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A27\"></a> \n               <h3><a name=\"GUID-33ABB651-8E22-4CA8-A1FF-2D09B8984335\"></a>レッスンのセットアップ\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A26\"></a>このセクションを説明どおりに進めるために、レッスンを開始する前に次の手順を実行します。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A25\"></a><ol type=\"1\" start=\"1\">\n                  <li><span class=\"MenuCascade\" id=\"GUID-D80FBE92-009F-4521-9BD0-C92C2529ECB8\">アウトライナ(Outliner)</span>で <em class=\"mild\">Pants_HighRes</em> オブジェクトを選択し、<span class=\"MenuCascade\" id=\"GUID-86D947FE-5658-4800-9651-32E5A4CF9F11\">ディスプレイ &gt; 非表示 &gt; 選択項目の非表示(Display &gt; Hide &gt; Hide Selection)</span>を選択して、Pants_HighRes オブジェクトを非表示にします。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-76A7811F-BAA2-43C4-A60A-71E616829F7A\">アウトライナ(Outliner)</span>で <em class=\"mild\">Pants_LowRes</em> オブジェクトを選択して表示し、それから<span class=\"MenuCascade\" id=\"GUID-7FBE6F37-CFCF-4B85-9F40-13D540EDF139\">ディスプレイ &gt; 表示 &gt; 選択項目の表示(Display &gt; Show &gt; Show Selection)</span>を選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"code\">nClothAdvancedTutorials</span> ディレクトリを Maya プロジェクトとして設定していない場合は、設定します。 \n                     			 \n                  </li>\n               </ol> \n               <div class=\"section\"><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3429\"></a> \n                  <h4><a name=\"GUID-35F7528E-C02C-415A-B779-B0F90B23FB60\"></a>ジオメトリ キャッシュを読み込むする\n                  </h4> \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3428\"></a>アニメートされたキャラクタ上で nCloth ズボンをシミュレートする前に、キャラクタの胴体と靴をアニメートするジオメトリ キャッシュを読み込むする必要があります。\n                     \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A22\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A21\"></a>ジオメトリ キャッシュを読み込んで胴体と靴のメッシュをアニメートするには\n                  </p>\n                  <ol type=\"1\" start=\"1\">\n                     <li>シーン ビューで Body オブジェクトを選択します。 \n                        				\n                     </li>\n                     <li>メイン メニュー セットから、<span class=\"MenuCascade\" id=\"GUID-527FF58F-C8AE-44B2-9A3B-2B8CCF6FABDD\">キャッシュ &gt; ジオメトリ キャッシュ &gt; キャッシュの読み込み(Cache &gt; Geometry Cache &gt; Import Cache)</span>を選択します。 \n                        				\n                     </li>\n                     <li>表示される<span class=\"MenuCascade\" id=\"GUID-F5C4272E-9D4C-464C-9A81-475353D61932\">キャッシュ ファイルの読み込み(Import Cache File)</span>ウィンドウで、以下を行います。 \n                        				  <a name=\"WS73099CC142F48755527CC80126D167FFA2-7258\"></a><ul>\n                           <li><span class=\"MenuCascade\" id=\"GUID-425D1DFF-E669-455A-8B31-5DF6D1EBD4D4\">ファイルの種類(Files of type)</span>リストから<span class=\"MenuCascade\" id=\"GUID-2B29E6FA-BD62-4379-9639-58710A6BCB30\">すべてのファイル(All Files)</span>を選択します。 \n                              					 \n                           </li>\n                           <li><em class=\"mild\">nClothAdvancedTutorials ¥data フォルダを参照して <span class=\"code\">Body_Animation.mc</span>を選択します。</em> \n                           </li>\n                           <li><span class=\"MenuCascade\" id=\"GUID-366E0F33-6A4E-46A8-88F4-E06A3966666A\">開く(Open)</span>をクリックします。 \n                              					 \n                           </li>\n                        </ul> \n                     </li>\n                     <li>シーン ビューで、Shoes オブジェクトを選択し、手順 2 と 3 の説明に従って作業を進めます。キャッシュ ファイルのリストから <span class=\"code\">Body_Animation.mc</span> に代わって <span class=\"code\">Shoes_Animation.mc</span> を選択します。 \n                        				\n                     </li>\n                  </ol> \n               </div> \n            </div> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A1A\"></a>シミュレーションを再生し、アニメートされたキャラクタと一緒にシミュレートされたときの nCloth ズボンの動作を確認できます。ただし、<span class=\"MenuCascade\" id=\"GUID-627E664E-47AD-4247-8E86-AD4B1BF3E472\">タイム スライダ(Time Slider)</span>をスクラブできないとシミュレーションを詳細に検査することは困難です。シミュレーションの問題をより簡単に特定するには、nCloth ズボン オブジェクトのキャッシュを作成します。nCache\n               の詳細については、Maya ヘルプの「<em class=\"mild\">nCaching</em>」を参照してください。 \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A19\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A18\"></a>nCloth ズボンのシミュレーションをキャッシュするには\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>シーン ビューで、nCloth ズボンを選択します。 \n                  		  \n               </li>\n               <li><span class=\"MenuCascade\" id=\"GUID-09BD4E44-9ED9-4BF0-A607-6526816CA416\">nCache &gt; 新規キャッシュの作成 &gt; nObject (nCache &gt; Create New Cache &gt; nObject)</span> &gt; <img src=\"../images/GUID-96432FB8-EBE9-4D1A-8DED-5173E032EBC0-low.png\">を選択します。 \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A15\"></a><span class=\"MenuCascade\" id=\"GUID-76149E49-EB64-40FF-AE1B-2B8F72F9587D\">nCache の作成オプション(Create nCache Options)</span>ウィンドウが表示されます。 \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E34\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-EA9647AC-976B-4245-9214-1D05920A75E1-low.png\"></div> \n               </li>\n               <li><span class=\"MenuCascade\" id=\"GUID-CA3DA486-7523-408E-B5A8-4FD87FC175BA\">nCache の作成オプション(Create nCache Options)</span>ウィンドウで、以下を実行します。 \n                  			 <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A13\"></a><ul>\n                     <li>キャッシュを保存するフォルダに<span class=\"MenuCascade\" id=\"GUID-1462680B-3538-4B2F-9121-B29CE6AB87AE\">キャッシュ ディレクトリ(Cache Directory)</span>を設定します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-CF547B16-03BD-4E32-8023-636FD9164A16\">キャッシュ名(Cache Name)</span>に nCloth_PantsShape を設定します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-A3963C8A-76F4-4052-916D-D434B45B5067\">ファイル配分(File distribution)</span>の項目にある <span class=\"MenuCascade\" id=\"GUID-EC20898A-804A-43AC-87D3-BF7BB0AE08CA\">1 ファイル(One File)</span>を選択します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-641B7C3C-D49B-460C-ABF9-8DF1C7997685\">作成(Create)</span>ボタンをクリックします。 \n                        				\n                     </li>\n                  </ul> \n               </li>\n               <li>シミュレーションを再生します。 \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A0E\"></a> \n            <h2><a name=\"GUID-F2DF1143-35C9-4358-A82B-A21F1C784F2E\"></a>シミュレートされた nCloth で問題領域を特定する\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A0D\"></a>シミュレーションを再生すると、nCloth ズボン オブジェクトに次の問題があることがわかります。 \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A0C\"></a><ul>\n               <li>フレーム 1025 と 1035 の間で、ウエストとズボンの股部分の周囲のポリゴン フェースに質の悪い自己衝突が表示されており、結果として相互貫通が発生しています。また、膝の前と後のポリゴン\n                  フェースは質が悪く、一部のポリゴンが外方向に突き出して、クロスが重く固そうに見えます。 \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E33\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D3C43B4B-92D7-45C5-8A9E-DD585363FDD8-low.png\"></div> \n               </li>\n               <li>フレーム 1037 では、足首周りのポリゴン フェースは互いに折り重なり、トラップされています。 \n                  		  \n               </li>\n               <li>フレーム 1040 と 1045 の間では、ズボンのウエスト、膝、裾の折り返しにまだ自己衝突の問題が残っています。 \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E32\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-C33763F8-2FAB-430A-97D3-815EB2611F88-low.png\"></div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E31\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-7D4D006F-0A4E-42E4-A196-DC14CAB46E9B-low.png\"></div> \n               </li>\n            </ul> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A07\"></a><span class=\"MenuCascade\" id=\"GUID-5356164E-7793-4962-A724-377EB2540D95\">タイム スライダ(Time Slider)</span>をスクラブしながらシーンをドリー、タンブルし、各問題領域に接近して観察できるようにします。 \n               		\n            </p> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A06\"></a> \n               <h3><a name=\"GUID-095E19D8-B7E0-4AAD-9ECA-EC9674811E8F\"></a><span class=\"MenuCascade\" id=\"GUID-6AFE2885-57B3-419E-8554-218698AF0008\">サブステップ(Substeps)</span>を編集する\n               </h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7396\"></a>シミュレーションの問題の修正に役立つ最初の手順は、nucleus ソルバの<span class=\"MenuCascade\" id=\"GUID-290D07D8-D9C8-4B5D-9162-EA0B998FCFF3\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-07B276D1-3A41-4DAB-8E15-9F205A08C4C0\">衝突最大反復回数(Max Collision Iterations)</span>の数を増やすことです。<span class=\"MenuCascade\" id=\"GUID-DD653ED4-E9F6-419C-B2B0-73D7780883CD\">サブステップ(Substeps)</span>は、nCloth とパッシブ衝突オブジェクト間の衝突の検出から<span class=\"MenuCascade\" id=\"GUID-069A3AD4-F9D0-45AB-A6C8-8ED8F22BA767\">ダイナミック プロパティ(Dynamic Properties)</span>アトリビュートとダイナミック コンストレイントのエフェクトまで、Maya Nucleus ソルバがシミュレーションに含まれるすべてを計算するフレームごとの回数を指定します。<span class=\"MenuCascade\" id=\"GUID-39BA31FB-2C7C-4004-9CAD-3EFD07871C11\">サブステップ(Substeps)</span>を調整すれば、シミュレーション時間をどのように分割して計算セグメントにするかをコントロールできます。一般的にはシミュレーション精度と衝突精度は、サブステップ(Substeps)値を増やすと向上します。<span class=\"MenuCascade\" id=\"GUID-21C35ABF-E310-4987-97B0-92C9F24BD753\">衝突最大反復回数(Max Collision Iterations)</span>は、Maya Nucleus ソルバのフレームごとの衝突反復の最大回数を指定します。<span class=\"MenuCascade\" id=\"GUID-DE1D66C1-AA91-4219-AFBE-749E4FBD0DF6\">サブステップ(Substeps)</span>または<span class=\"MenuCascade\" id=\"GUID-9017A021-E9C7-4BAA-887F-BCC27765B77A\">衝突最大反復回数(Max Collision Iterations)</span>が多いと、ソルバが遅くなる可能性があります。 \n                  		  \n               </p> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A04\"></a>シーンの複雑さによっては、重力と風のみが nCloth オブジェクトに作用する静止シーンをシミュレートする場合には、既定値である<span class=\"MenuCascade\" id=\"GUID-B8590A46-C08C-4810-A873-92C7638131CA\">サブステップ(Substeps)</span>を 3、<span class=\"MenuCascade\" id=\"GUID-42DFA0BA-E2D3-4F57-AC65-E8FB5F01D055\">衝突最大反復回数(Max Collision Iterations)</span>を 4 に設定するとうまくいくこともあります。nCloth が移動し始めて自己衝突する場合は、特に高速に移動するオブジェクトで衝突を正確に検出できるように、<span class=\"MenuCascade\" id=\"GUID-68F39757-A6FB-4650-B9A8-38FC2CE91201\">サブステップ(Substeps)</span>値を大きくする必要があります。nCloth 衝突の数が増加した場合や、ダイナミック コンストレイントがオブジェクトに追加された場合には、<span class=\"MenuCascade\" id=\"GUID-B0E5058D-1AC7-43FB-AE0A-C9E9C75461A0\">衝突最大反復回数(Max Collision Iterations)</span>を増やすことが重要になります。詳細については、Maya ヘルプの「<em class=\"mild\">nCloth ダイナミック プロパティ</em>」を参照してください。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A03\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A02\"></a><span class=\"MenuCascade\" id=\"GUID-30483BAD-AA3A-4E80-B2AE-6C5CCAE7CAA7\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-F9072FD6-E12E-4C3F-AD96-364FC232BA77\">衝突最大反復回数(Max Collision Iterations)</span>を編集するには\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li><span class=\"MenuCascade\" id=\"GUID-CB319FFF-95DF-454F-A6BF-2BB01DB91BF9\">アトリビュート エディタ(Attribute Editor)</span>で、<span class=\"MenuCascade\" id=\"GUID-F3A06029-E284-46E3-A36B-D711D48D4134\">nucleus1</span> タブを選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-6FAAA1AE-BCB5-4B8D-8FFF-5ED26FB11C29\">ソルバ アトリビュート(Solver Attributes)</span>セクションで、以下を実行します。 \n                     				<a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-39FF\"></a><ul>\n                        <li><span class=\"MenuCascade\" id=\"GUID-4736E987-DB86-4A39-9E90-CF9F1AE77E03\">サブステップ(Substeps)</span>を 7 に設定します。 \n                           				  \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-62F82010-D8D1-4D5B-B7EE-B62294E8D700\">衝突最大反復回数(Max Collision Iterations)</span>を 8 に設定します。 \n                           					 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E30\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-643E8A0C-3433-4DDD-9FA0-2BD1B9D9DFA3-low.png\"></div> \n                        </li>\n                     </ul> \n                  </li>\n                  <li>シミュレーションを再生してこの新しい設定の結果を確認する前に、シミュレーションの前の nCache を置き換えるか、新規 nCache を作成する必要があります。そうしないと、変更内容がシミュレーションに表示されません。\n                     \n                     				\n                     <p><a name=\"WS73099CC142F487557230B50811D7D192C64-74A8\"></a>キャッシュ ファイルを置き換えると、既存の nCache は新規ファイルで上書きされます。レッスンではシミュレーションを何度もキャッシュするため、<span class=\"MenuCascade\" id=\"GUID-89DC1542-E4DC-46A5-BF33-9AE915AC8923\">キャッシュの置き換え(Replace Cache)</span>を使用してハード ディスクに保存されるキャッシュ ファイルの数を少なくするのが最適です。前の nCache を置き換えるには、<span class=\"MenuCascade\" id=\"GUID-FF8173D9-CD3F-47D1-B7CA-92C5FEACAC2B\">nCache &gt; Cache の置き換え &gt; nObject(nCache &gt; Replace Cache &gt; nObject)</span>を選択します。 \n                        				\n                     </p> \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-4F443AF4-45EB-46B0-8657-9271BFD55B98\">キャッシュの作成の警告(Create Cache Warning)</span>が表示されたら、<span class=\"MenuCascade\" id=\"GUID-A9CF92E9-08CB-4375-A0F8-0BC384D437B2\">既存の置き換え(Replace Existing)</span>をクリックします。 \n                     			 \n                  </li>\n                  <li>シミュレーションを再生します。 \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-39FA\"></a>シミュレーションを再生すると、フレーム 1030 以降で、ひざの領域のポリゴン フェースがよりリアルになっているのがわかります。クロスのデフォメーションがより多くのフェース上に広がり、よりリアルに見えるようになりました。ただし、シミュレーションの問題がすべて解決されたわけではありません。<span class=\"MenuCascade\" id=\"GUID-D22878B3-CE76-4485-A22C-0BC47EE4408D\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-3BCECAF2-656C-4C0E-932E-098E3A0C0F7E\">衝突最大反復回数(Max Collision Iterations)</span>により大きい値を設定する必要がある場合もあります。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-98E886FD-86E2-4AA2-BBE3-5D22206E8DF3-low.png\"></div> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D15\"></a><span class=\"MenuCascade\" id=\"GUID-F0246D53-CC65-436B-85D7-C3510FBD98B7\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-6354DBD4-138C-422D-BE99-BC86D8CB06CA\">衝突最大反復回数(Max Collision Iterations)</span>を増やすと、nucleus ソルバはシミュレートされる各ステップでより多くの計算を実行することになるため、結果としてシミュレーション速度が遅くなります。シミュレーションの精度とパフォーマンスのバランスをとるには、シミュレーションでより高い<span class=\"MenuCascade\" id=\"GUID-9FAF1A8D-7139-4D29-9E50-1B8AF9963639\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-C392CD5A-8BDF-4083-B48B-715272E2F8CC\">衝突最大反復回数(Max Collision Iterations)</span>が必要な領域やフレームを特定しておくと役に立ちます。キーフレームを設定して、シミュレーションの存続中に<span class=\"MenuCascade\" id=\"GUID-C00BFF10-9E48-40EF-B357-2ED96F20B2F6\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-6AE02374-4891-459D-99F8-2EB41A437AD3\">衝突最大反復回数(Max Collision Iterations)</span>の値をアニメートできます。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D14\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D13\"></a><span class=\"MenuCascade\" id=\"GUID-82D11AE3-04B5-40D0-9676-BCBBCCBC9BAC\">サブステップ(Substeps)</span>と<span class=\"MenuCascade\" id=\"GUID-6D0093F6-97B8-432D-88E3-D082084D506B\">衝突最大反復回数(Max Collision Iterations)</span>にキーフレームを設定するには\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li><span class=\"MenuCascade\" id=\"GUID-143979CE-2D4A-445B-97AD-ECF838F175F2\">タイム スライダ(Time Slider)</span>で、フレーム 1000 に進みます。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-87F0800C-B46E-468F-98BA-29C193E40C97\">アトリビュート エディタ(Attribute Editor)</span>で、<span class=\"MenuCascade\" id=\"GUID-74ED02BE-0DB5-45C7-8DD1-A15CA9F17F7D\">nucleus1</span> タブを選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-E637D00E-EAC7-4F4A-B63B-4DC06E0D0786\">ソルバ アトリビュート(Solver Attributes)</span>セクションで、以下を実行します。 \n                     				<a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D0F\"></a><ul>\n                        <li><span class=\"MenuCascade\" id=\"GUID-546FA1B7-3433-43F2-AE80-2EC8DA715F43\">サブステップ(Substeps)</span>を 5 に設定します。 \n                           				  \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-84565A20-CE42-4D4E-B429-55D5675BD32C\">サブステップ(Substeps)</span>アトリビュート フィールドを右クリックして、ポップアップ メニューから<span class=\"MenuCascade\" id=\"GUID-E393EEA0-C889-415D-8D73-9AA97163512D\">キーの設定(Set Key)</span>を選択します。 \n                           					 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2E\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-15422F39-DBC5-4554-8AF0-E22F9EA5D9B7-low.png\"></div> \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-A8512AB2-DFA6-4AEE-B34C-DD037C8E5CD0\">衝突最大反復回数(Max Collision Iterations)</span>を 6 に設定します。 \n                           				  \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-5E6770FD-FDC5-426A-9C5A-44BD7DFC00B7\">衝突最大反復回数(Max Collision Iterations)</span>アトリビュート フィールドを右クリックして、ポップアップ メニューから<span class=\"MenuCascade\" id=\"GUID-AB5F0A29-4ABB-4307-B377-6820295728D5\">キーの設定(Set Key)</span>を選択します。 \n                           				  \n                        </li>\n                     </ul> \n                  </li>\n                  <li>次の表の値を使用して、シミュレーションでのキーフレームの設定を続けます。 \n                     				<a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D09\"></a><div class=\"table-ruled\">\n                        <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                           <colgroup>\n                              <col width=\"33.33333333333333%\">\n                              <col width=\"33.33333333333333%\">\n                              <col width=\"33.33333333333333%\">\n                           </colgroup>\n                           <tr class=\"ruled-heading\">\n                              <th class=\"table-heading\">フレーム \n                                 						  \n                              </th>\n                              <th class=\"table-heading\"> <span class=\"MenuCascade\" id=\"GUID-B7B8EE62-CD60-4087-96CF-A9A1690CB39A\">サブステップ(Substeps)</span> \n                              </th>\n                              <th class=\"table-heading\"> <span class=\"MenuCascade\" id=\"GUID-668BCD73-7E0C-42CB-BD46-545281089BA7\">衝突最大反復回数(Max Collision Iterations)</span> \n                              </th>\n                           </tr>\n                           <tr class=\"ruled-odd-row\">\n                              <td class=\"table-body\">1019 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">5 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">6 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-even-row\">\n                              <td class=\"table-body\">1020 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">7 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">8 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-odd-row\">\n                              <td class=\"table-body\">1022 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">9 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">12 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-even-row\">\n                              <td class=\"table-body\">1025 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">15 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">20 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-odd-row\">\n                              <td class=\"table-body\">1060 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">9 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">12 \n                                 						  \n                              </td>\n                           </tr>\n                        </table>\n                     </div> \n                  </li>\n                  <li>シミュレーションをキャッシュ(<span class=\"MenuCascade\" id=\"GUID-F3087307-7250-49A1-8103-565152C2347A\">nCache &gt; キャッシュの置き換え &gt; nObject(nCache &gt; Replace Cache &gt; nObject)</span>)してから再生します。 \n                     			 \n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D07\"></a> \n               <h3><a name=\"GUID-5724129B-F7D4-43D1-9162-8F3980405B85\"></a>nCloth アトリビュートを微調整する\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D06\"></a>キャッシュを再生すると、シミュレーションの全体的な精度が改良されていることがわかります。ただし、ウエストと股部分にまだ問題領域があります。たとえば、フレーム 1030\n                  では、股領域の質の悪い自己衝突の結果、望ましくないポリゴン デフォメーションが作成されています。シミュレーションの精度を向上させるために、<span class=\"MenuCascade\" id=\"GUID-44401F5A-DE8F-4D0C-B424-DC2773C3E739\">ダイナミック プロパティ(Dynamic Properties)</span>アトリビュートの微調整を開始します。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2D\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-F72CC859-9623-4F5E-A812-0A6129B6D096-low.png\"></div> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D05\"></a><span class=\"MenuCascade\" id=\"GUID-42800A84-3966-47FF-9343-7280DCD36774\">ダイナミック プロパティ(Dynamic Properties)</span> アトリビュートなどの nCloth アトリビュートを細かく調整する場合は、シミュレーションのさまざまなフレームで nCloth メッシュの複製を作成しておくと役立ちます。シミュレーションを再生するときに、現在シミュレート中の\n                  nCloth を複製メッシュと比較して、次の項目について評価できます。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D04\"></a><ul>\n                  <li>調整が必要なアトリビュートを正しく特定しているか。 \n                     			 \n                  </li>\n                  <li>調整は nCloth の動作にどのように作用するか。 \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D01\"></a>股領域の問題を解決するには、<span class=\"MenuCascade\" id=\"GUID-85D646AD-0767-45DA-A9EF-C92171755352\">ベンドの抵抗(Bend Resistance)</span>を大きくしてポリゴンのエッジの形状が適切になるようにします。詳細については、Maya ヘルプの「<em class=\"mild\">nCloth ダイナミック プロパティ</em>」を参照してください。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D00\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CFF\"></a>複製メッシュを作成してベンドの抵抗を編集するには\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li><span class=\"MenuCascade\" id=\"GUID-902A6C16-5DCA-4EFC-B761-0FA7CFEFEF59\">タイム スライダ(Time Slider)</span>で、フレーム 1030 に進みます。 \n                     			 \n                  </li>\n                  <li>シーン ビューで、nCloth ズボンを選択して<span class=\"MenuCascade\" id=\"GUID-1D6C18D8-F746-4764-8CF8-CFBEA1EF9EBA\">編集 &gt; 複製(Edit &gt; Duplicate)</span>を選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-60ED5737-F91B-4201-9A3B-A41736B9170A\">アウトライナ(Outliner)</span>で <em class=\"mild\">Pants_LowRes1</em> を選択し、シーン ビューでメッシュ オブジェクトをキャラクタの右に移動します。 \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-34C3FC5C-F5B5-45C9-B027-C7D0E674B2BC-low.png\"></div> \n                  </li>\n                  <li>シーン ビューでオリジナルの nCloth ズボン オブジェクトを選択し、<span class=\"MenuCascade\" id=\"GUID-8462E23B-7D78-4302-8F17-FD8E36579750\">アトリビュート エディタ(Attribute Editor)</span>で <span class=\"MenuCascade\" id=\"GUID-427D521A-FADD-49A6-9603-256B81FBC3F7\">nCloth_PantsShape</span> タブをクリックします。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-B1B0ECFB-7DE4-44B2-B7EC-722D0FD2413B\">ダイナミック プロパティ(Dynamics Properties)</span>セクションで、<span class=\"MenuCascade\" id=\"GUID-1E7AB71C-0C9A-48F8-928B-DEEF72F3D08D\">ベンドの抵抗(Bend Resistance)</span>を 5 に設定します。 \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2B\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-B43576C8-9BC7-48AE-A235-7FB49B219758-low.png\"></div> \n                  </li>\n                  <li>シミュレーションをキャッシュして(<span class=\"MenuCascade\" id=\"GUID-3237CE8F-E4C8-4F93-87C6-ABB5D30EE7D6\">nCache &gt; キャッシュの置き換え &gt; nObject(nCache &gt; Replace Cache &gt; nObject))</span>、再生します。 \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CF8\"></a>シミュレーションを再生すると、股領域のクロスがよりリアルにカーブしているのがわかります。<span class=\"MenuCascade\" id=\"GUID-E5AAE801-C5E1-4D92-8F33-56737B140B3A\">タイム スライダ(Time Slider)</span>でフレーム 1030 に進み、シミュレートされた nCloth を複製メッシュと比較します。シーンをドリー、タンブルし、改良された領域に接近して観察できるようにします。\n                  \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-1AB6FF1A-BA2A-4BB3-904E-C13602143912-low.png\"></div> \n               <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E4\"></a> \n                  <h4><a name=\"GUID-F8A5C75C-6C60-49F5-9A78-972ECDBBAFE9\"></a>精度設定を編集して相互貫通を解決する\n                  </h4> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E3\"></a>シミュレーションを再生して問題領域を複製メッシュと比較すると、フレーム 1030 と 1035 の間にまだ問題領域が残っていることがわかります。 \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E29\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-DAE2C72C-F56B-4B34-9954-878951CDE43E-low.png\"></div> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D6B\"></a>シミュレーション精度を向上させるもう 1 つの方法として、<span class=\"MenuCascade\" id=\"GUID-16C22CEF-BFBB-4723-9B34-1F51C2DEAA80\">自己衝突フラグ(Self Collision Flag)</span>と<span class=\"MenuCascade\" id=\"GUID-2EE8084B-DE14-44DB-862B-1CDE5624D756\">精度設定(Quality Settings)</span>アトリビュートの編集があります。これは nCloth コンポーネントの衝突と自己衝突に作用します。既定では、<span class=\"MenuCascade\" id=\"GUID-37C1BEF8-1ABD-4D78-95F5-CF59C6899027\">自己衝突フラグ(Self Collision Flag)</span>は<span class=\"MenuCascade\" id=\"GUID-26E062C2-6F3D-4090-9EC5-EB9A56998D54\">頂点フェース(VertexFace)</span>に設定されています。つまり nCloth オブジェクトの頂点とフェースが互いに衝突します。<span class=\"MenuCascade\" id=\"GUID-CBCD712D-05FA-4C0E-AE9A-0C84E9A1E7F2\">自己衝突フラグ(Self Collision Flag)</span>を<span class=\"MenuCascade\" id=\"GUID-4EA99570-B98F-4D81-A2DF-85E6A75CD6C8\">完全なサーフェス(Full Surface)</span>に設定すると、すべてのオブジェクト コンポーネント(頂点、エッジ、フェース)が自己衝突の対象として設定されます。 \n                     			 \n                  </p> \n                  <p><a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-588C\"></a>低解像度メッシュをシミュレートする場合は、メッシュの頂点、エッジ、およびフェースの数が少ないため、nCloth オブジェクトの潜在的な自己衝突領域の数を増やすことが重要です。高解像度の\n                     nCloth メッシュで<span class=\"MenuCascade\" id=\"GUID-C276C614-548F-446B-AFC2-98F92A5621BB\">自己衝突フラグ(Self Collision Flag)</span>を<span class=\"MenuCascade\" id=\"GUID-49741BB7-1C5B-4857-BEAC-8D8D9D139CF6\">完全なサーフェス(Full Surface)</span>に設定すると、シミュレーション時間が長くなります。この問題は低解像度メッシュでは軽減されるため、反復シミュレーション テストではこの代替が非常に有用です。詳細については、Maya\n                     ヘルプの「<em class=\"mild\">nCloth 衝突アトリビュート</em>」を参照してください。 \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D6A\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D69\"></a><span class=\"MenuCascade\" id=\"GUID-1CD37885-9F17-4187-A91F-D8BFE004586F\">自己衝突フラグ(Self Collision Flag)</span> アトリビュートを編集するには\n                  </p>\n                  <ol type=\"1\" start=\"1\">\n                     <li><span class=\"MenuCascade\" id=\"GUID-AA82963E-9C2F-46D2-905A-AC02A6197353\">タイム スライダ(Time Slider)</span>で、フレーム 1033 に進みます。 \n                        				\n                     </li>\n                     <li>シーン ビューで、nCloth ズボンを選択して<span class=\"MenuCascade\" id=\"GUID-366C7E2E-8258-4622-BBD9-4295D7D17F51\">編集 &gt; 複製(Edit &gt; Duplicate)</span>を選択します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-D9A6A311-2E7E-420F-87A8-C84F9FC677EE\">アウトライナ(Outliner)</span>で <em class=\"mild\">Pants_LowRes2</em> を選択し、シーン ビューでメッシュ オブジェクトをキャラクタの左に移動します。 \n                        				  <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E28\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-2461E1DB-2EB2-4152-9363-6E5BF92D7563-low.png\"></div> \n                     </li>\n                     <li>シーン ビューでオリジナルの nCloth ズボン オブジェクトを選択し、<span class=\"MenuCascade\" id=\"GUID-AF6B0A8A-8534-4265-9A9E-710E389DAEC2\">アトリビュート エディタ(Attribute Editor)</span>で <span class=\"MenuCascade\" id=\"GUID-143DB696-2FA5-4FA6-819B-73730193982B\">nCloth_PantsShape</span> タブをクリックします。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-1F0C4365-F299-4D23-9209-7464BF6A1945\">衝突(Collisions)</span>セクションで、<span class=\"MenuCascade\" id=\"GUID-33526C0B-198F-4305-9981-F8E7E89C1CF1\">自己衝突フラグ(Self Collision Flag)</span>を<span class=\"MenuCascade\" id=\"GUID-3ECAFF09-610A-4AE6-AB9F-149746B1EED9\">完全なサーフェス(Full Surface)</span>に設定します。 \n                        				  <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E27\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-1C6106AB-DD9D-4F64-9A8A-BAE75CC01D2E-low.png\"></div> \n                     </li>\n                  </ol> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D62\"></a><span class=\"MenuCascade\" id=\"GUID-0012101A-F314-4909-97A0-7AE952481341\">自己衝突フラグ(Self Collision Flag)</span>アトリビュートを<span class=\"MenuCascade\">完全なサーフェス(Full Surface）</span>に設定すると、自己衝突が改善されますが、トラップされた自己衝突頂点を作成することがあります。<span class=\"MenuCascade\" id=\"GUID-1054860C-8156-4E78-94CC-E215C66AD67D\">精度設定(Quality Settings)</span> を編集してこの問題を解決したり、nCloth ズボン オブジェクトと nRigid 靴オブジェクト間の残った相互貫通を解決することができます。また、<span class=\"MenuCascade\" id=\"GUID-BCF9EE49-7A55-4C07-8808-197695AD27A0\">厚み(Thickness)</span>を増やすか、<span class=\"MenuCascade\" id=\"GUID-B6036190-E2C3-41E5-9451-16D722C058A9\">厚みマップ(Thickness Map)</span>を作成して衝突検出を改良することもできます。 \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E1\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E0\"></a><span class=\"MenuCascade\" id=\"GUID-F2445603-FD02-4C97-8D9F-B2CD07FDDF26\">精度設定(Quality Settings)</span>を編集するには\n                  </p>\n                  <ol type=\"1\" start=\"1\">\n                     <li><span class=\"MenuCascade\" id=\"GUID-1D1A640A-E917-4B90-90D6-0B08CD6FB921\">アトリビュート エディタ(Attribute Editor)</span>で、<span class=\"MenuCascade\" id=\"GUID-1C6FD334-7EA7-4CFF-8D4E-51A340F0E0FC\">nCloth_PantsShape</span> タブを選択します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-CF73B2EE-C44E-435B-813F-4665101ACF65\">精度設定(Quality Settings)</span>セクションで、次の操作を実行します。 \n                        				  <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62DD\"></a><ul>\n                           <li><span class=\"MenuCascade\" id=\"GUID-D8F164C7-BFE2-462B-A4A7-0B3AFF019284\">最大反復回数(Max Iterations)</span>が 10000 に設定されていることを確認します。 \n                              					 \n                           </li>\n                           <li><span class=\"MenuCascade\" id=\"GUID-DC8E07AA-BE59-4632-8A72-AA3BC14185BB\">トラップ チェック(Trapped Check)</span>をオンにします。 \n                              					 \n                           </li>\n                           <li><span class=\"MenuCascade\" id=\"GUID-784F4BA0-9597-476C-BC3A-5C2F95721407\">自己トラップのチェック(Self Trapped Check)</span>をオンにします。 \n                              						<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E26\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D8736D0F-D942-48EF-A1C7-96D3611A1841-low.png\"></div> \n                           </li>\n                        </ul> \n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-61FE00C1-82BD-4732-9E1F-1F856D3636A4\">nCache &gt; キャッシュの置き換え &gt; nObject(nCache &gt; Replace Cache &gt; nObject)</span>でシミュレーションをキャッシュして、再生します。 \n                        				\n                     </li>\n                  </ol> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D61\"></a><span class=\"MenuCascade\" id=\"GUID-208FCDB0-7E8E-4AC0-BEE7-BF3797AD8908\">タイム スライダ(Time Slider)</span>で、フレーム 1033 に進み、シミュレートされた nCloth を複製メッシュと比較します。タイムラインをスクラブしながらシーンをドリー、タンブルし、問題領域に接近して観察できるようにします。満足な結果が得られたら、<em class=\"mild\">Pants_LowRes1</em> と <em class=\"mild\">Pants_LowRes2</em> の複製メッシュを削除します。 \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E25\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-E1B1666D-23D3-45FD-9F95-C9EAD4792362-low.png\"></div> \n               </div> \n            </div> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD3\"></a> \n               <h3><a name=\"GUID-EE32C491-DB5D-4926-9DF7-5F4FFDD9380A\"></a>ラップされた nCloth シミュレーションをシミュレートされた高解像度メッシュと比較する\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD2\"></a>nCloth ズボン オブジェクトのアトリビュート調整を完了するには、ラップされた nCloth シミュレーションをリファレンス キャラクタ オブジェクト(オリジナルのシミュレートされた高解像度メッシュ)と比較します。\n                  \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD1\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD0\"></a>低解像度と高解像度の nCloth メッシュを比較するには\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li><span class=\"MenuCascade\" id=\"GUID-F17301FD-230A-43A2-855B-B6A407349711\">アウトライナ(Outliner)</span>で Pants_LowRes オブジェクトを選択して非表示にし、それから<span class=\"MenuCascade\" id=\"GUID-709715CA-7AF8-40C7-A642-E220AC663E40\">ディスプレイ &gt; 非表示 &gt; 選択項目の非表示(Display &gt; Hide &gt; Hide Selection)</span>を選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-27DD03EC-E080-45A9-A295-A6F16B5F0539\">アウトライナ(Outliner)</span>で Pants_HighRes オブジェクトを選択してこれを表示し、それから<span class=\"MenuCascade\" id=\"GUID-E6C50E83-8BD4-4E48-98A0-29E992C9AFA2\">ディスプレイ &gt; 表示 &gt; 選択項目の表示(Display &gt; Show &gt; Show Selection)</span>を選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-6528DDFE-1553-40A9-8417-532115C90674\">ディスプレイ レイヤ エディタ(Display Layer Editor)</span> (<span class=\"MenuCascade\" id=\"GUID-66FC8CF8-C452-42A2-94D8-5D408F410621\">チャネル ボックス(Channel Box)/レイヤ エディタ(Layer Editor) &gt; ディスプレイ(Display)タブ &gt; レイヤ(Layers) &gt;\n                        選択したレイヤを設定(Set Selected Layers)</span>)で、可視(Visible)をオンにしてシーン ビューに Reference_Character オブジェクトを表示します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-F6C40F9F-2D39-4602-959E-6339FFCDA1B9\">アウトライナ(Outliner)</span>で Reference_Shirt オブジェクトを選択して非表示にし、それから<span class=\"MenuCascade\" id=\"GUID-57614FCA-C129-4C96-A1AD-E16889D2EA37\">ディスプレイ &gt; 非表示 &gt; 選択項目の非表示(Display &gt; Hide &gt; Hide Selection)</span>を選択します。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-0BB3BEBF-5830-4C88-BFFC-10115CE806C0\">シェーディング(Shading)</span>メニューで、<span class=\"MenuCascade\" id=\"GUID-5E5E5ACB-A5E3-4242-ADF2-FCF346DDD11F\">ワイヤフレーム付きシェード(Wireframe on Shaded)</span>をオンにします。 \n                     			 \n                  </li>\n                  <li><span class=\"MenuCascade\" id=\"GUID-2E57BF9D-4C21-4078-8073-5E3C833F9628\">タイム スライダ(Time Slider)</span>をスクラブして、アニメーションでの nCloth メッシュの動作を比較します。タイムラインをスクラブしながらシーンをドリーおよびタンブルし、問題領域に接近して観察できるようにします。\n                     \n                     				\n                     <div><a name=\"WS73099CC142F487557230B50811D7D192C64-74A7\"></a><div class=\"note-note\"><span class=\"label label-target-language\">注:</span> \n                           <p><a name=\"GUID-600BC39F-3DA4-4A3E-8F25-DF1CEAA65D2F\"></a>シミュレーションを再生またはスクラブしたときにシーン ビューで Reference_Character がアニメートされない場合は、必要に応じてリファレンス キャラクタのキャッシュをその個々のオブジェクトに再接続してください。詳細については、<span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3426\">既存のキャッシュにオブジェクトを再接続する</a></span>を参照してください。 \n                              				  \n                           </p> \n                        </div>\n                     </div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E24\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-3F9DF6A2-2FF3-4FC3-80CE-23BBF55E0E3A-low.png\"></div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E23\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-69B59E06-FB63-4DEC-91A0-623CC01E4612-low.png\"></div> \n                  </li>\n               </ol> \n               <div class=\"section\"><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3426\"></a> \n                  <h4><a name=\"GUID-B83DA460-103F-4290-8DF3-9B995F1485D2\"></a>既存のキャッシュにオブジェクトを再接続する\n                  </h4> <a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3425\"></a><ol type=\"1\" start=\"1\">\n                     <li><span class=\"MenuCascade\" id=\"GUID-BBB424C7-87AD-440C-9040-268CCD7517AB\">アウトライナ(Outliner)</span>で、キャッシュを再接続するオブジェクトを選択します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-CC2BE82C-3E16-4F8B-82B8-FE13791813B9\">アトリビュート エディタ(Attribute Editor)</span>で、オブジェクトのキャッシュ ノードを選択します。 \n                        				  \n                        <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3422\"></a>たとえば、キャラクタの胴体のキャッシュを再接続する場合は、<span class=\"MenuCascade\" id=\"GUID-089745B6-1CFF-4F93-A40E-0571D9F9398A\">Body_AnimationCache1</span> タブを選択します。 \n                           				  \n                        </p> \n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-B166E613-F12C-4E96-9648-551A4FFDA63D\">キャッシュ ファイル(Cache File)</span>セクションで <img src=\"../images/GUID-A194DBA7-DE15-428A-BA1C-441AAF942080-low.png\"> アイコンをクリックして、<span class=\"MenuCascade\" id=\"GUID-88048C18-C4E1-45AF-96FA-385152AEB334\">ベース ディレクトリ(Base Directory)</span>が <span class=\"code\">nClothAdvancedTutorials</span> プロジェクトの <span class=\"code\">data</span> フォルダに設定されていることを確認します。 \n                        				\n                     </li>\n                     <li><span class=\"MenuCascade\" id=\"GUID-C6697C81-0D5D-4717-805D-36F0E3FBB69F\">キャッシュ ディレクトリの割り当て(Assign Cache Directory)</span>ウィンドウの<span class=\"MenuCascade\" id=\"GUID-6410AD22-F0E2-4643-BFEE-D74FC26036B7\">開く(Open)</span>をクリックします。 \n                        				\n                     </li>\n                  </ol> \n               </div> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CCB\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CCA\"></a>観察\n               </p> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC9\"></a>シミュレーションを再生またはスクラブすると、次のことを確認できます。 \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC8\"></a><ul>\n                  <li>全体的に見て、ラップされた nCloth ズボンとリファレンス キャラクタ オブジェクトは同じように動作します。 \n                     			 \n                  </li>\n                  <li>フレーム 1040 と 1047 の間では、nCloth ズボン オブジェクトのズボンの脚は、リファレンス キャラクタ オブジェクトのズボンの脚より少し速く落ちていきます。\n                     \n                     			 \n                  </li>\n               </ul> \n               <div><a name=\"WS1A9193826455F5FF211A40BE11DCC57291C-72CA\"></a><div class=\"note-tip\"><span class=\"label label-target-language\">ヒント:</span> nCloth ズボンの脚をリファレンス キャラクタ オブジェクトのズボンの脚と同じ方法でシミュレートするには、<span class=\"MenuCascade\" id=\"GUID-5B6DB957-6FAA-408C-8946-2C7072B96516\">摩擦(Friction)</span>アトリビュートを調整します。 \n                     		  \n                  </div>\n               </div> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">このトピックについてのコメントをお送りください</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/deed.ja\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>特に明記されている場合以外は、この作業は、<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/deed.ja\" target=\"_blank\">Creative Commons 表示 - 非営利 - 継承 3.0 非移植ライセンス</a> のもと認可を受けています。 <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> (英語版) を参照してください。</em></p><br></div>\n   </body>\n</html>";